/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.serialization;

import fuzs.puzzleslib.config.serialization.ConfigDataSetImpl;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface ConfigDataSet<T> {
    public static final String CONFIG_DESCRIPTION = "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. Path may use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*shulker_box\" to match all shulker boxes no matter of color.";

    public Map<T, Object[]> toMap();

    default public boolean contains(T entry) {
        return this.toMap().containsKey(entry);
    }

    default public Object[] get(T entry) {
        if (!this.contains(entry)) {
            throw new NullPointerException("no data found for %s".formatted(entry));
        }
        return this.toMap().get(entry);
    }

    default public boolean isEmpty() {
        return this.toMap().isEmpty();
    }

    default public int size() {
        return this.toMap().size();
    }

    public static <T> ConfigDataSet<T> of(ResourceKey<? extends Registry<T>> registryKey, List<String> values) {
        return ConfigDataSet.of(registryKey, values, (index, value) -> true, new Class[0]);
    }

    public static <T> ConfigDataSet<T> of(ResourceKey<? extends Registry<T>> registryKey, List<String> values, BiPredicate<Integer, Object> filter, Class<?> ... types) {
        return new ConfigDataSetImpl<T>(ConfigDataSet.getRegistryFromKey(registryKey), values, filter, types);
    }

    @SafeVarargs
    public static <T> List<String> toString(ResourceKey<? extends Registry<T>> registryKey, T ... entries) {
        Registry<T> registry = ConfigDataSet.getRegistryFromKey(registryKey);
        return Stream.of(entries).peek(Objects::requireNonNull).map(arg_0 -> registry.m_7981_(arg_0)).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    private static <T> Registry<T> getRegistryFromKey(ResourceKey<? extends Registry<T>> registryKey) {
        Registry registry = (Registry)Registry.f_122897_.m_7745_(registryKey.m_135782_());
        Objects.requireNonNull(registry, String.format("Registry for key %s not found", registryKey));
        return registry;
    }
}

